//
// Authors:
//   Thorsten Brunklaus <brunklaus@ps.uni-sb.de>
//
// Copyright:
//   Thorsten Brunklaus, 2003
//
// Last Change:
//   $Date: 2004/12/13 16:06:06 $ by $Author: tack $
//   $Revision: 1.2 $
//

#if defined(INTERFACE)
#pragma implementation "generic/StackFrame.hh"
#endif

#include "generic/StackFrame.hh"
#include "generic/Worker.hh"

word StackFrame::Clone() {
  u_int size = GetWorker()->GetFrameSize(this);
  Block *clone = Store::AllocMutableBlock(MIN_DATA_LABEL, size);
  for (u_int i = size; i--;)
    clone->InitArg(i, UnsafeGetArg(i));
  return clone->ToWord();
}
