//
// Author:
//   Leif Kornstaedt <kornstae@ps.uni-sb.de>
//
// Copyright:
//   Leif Kornstaedt, 2002
//
// Last Change:
//   $Date: 2003/09/26 09:20:54 $ by $Author: bruni $
//   $Revision: 1.4 $
//

#if defined(INTERFACE)
#pragma implementation "generic/UniqueString.hh"
#endif

#include "adt/ChunkMap.hh"
#include "generic/RootSet.hh"
#include "generic/UniqueString.hh"

static const u_int initialTableSize = 16; // to be checked

static word uniqueStringTable;

void UniqueString::Init() {
  uniqueStringTable = ChunkMap::New(initialTableSize)->ToWord();
  RootSet::Add(uniqueStringTable);
}

UniqueString *UniqueString::New(String *string) {
  ChunkMap *map = ChunkMap::FromWordDirect(uniqueStringTable);
  word key = string->ToWord();
  if (map->IsMember(key)) {
    return UniqueString::FromWordDirect(map->Get(key));
  } else {
    Block *b = Store::AllocBlock(UNIQUESTRING_LABEL, SIZE);
    b->InitArg(STRING_POS, key);
    b->InitArg(HASH_VALUE_POS, Store::IntToWord(string->Hash()));
    map->Put(key, b->ToWord());
    return STATIC_CAST(UniqueString *, b);
  }
}
